#ifndef _CUSTOMGUI_PRIORITY_H_
#define _CUSTOMGUI_PRIORITY_H_

#include "customgui_base.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "c4d_customdatatype.h"



#define CUSTOMGUI_PRIORITY                1009364
#define CUSTOMGUI_PRIORITY_DATA       		1009369

#define PRIORITY_FLAG_NOCAMERA						1000

#define PRIORITYVALUE_MODE								0
#define PRIORITYVALUE_PRIORITY						1
#define PRIORITYVALUE_CAMERADEPENDANT			2

#define CYCLE_INITIAL                     0
#define CYCLE_ANIMATION                   1
#define CYCLE_EXPRESSION                  2
#define CYCLE_DYNAMICS                    3
#define CYCLE_GENERATORS                  4

class PriorityCustomGui : public BaseCustomGui<CUSTOMGUI_PRIORITY>
{
private:
  PriorityCustomGui();
public:
  Bool SetValue(LONG lValueID, const GeData &data); // returns false on valueID <-> data type mismatch
  GeData GetValue(LONG lValueID);
};

class PriorityData : public iCustomDataType<PriorityData>
{
private:
  PriorityData() { }
public:
  Bool SetPriorityValue(LONG lValueID, const GeData &data); // same like above
  GeData GetPriorityValue(LONG lValueID);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#ifndef _INTERNAL_DEF_
	class iPriorityCustomGui : public iBaseCustomGui
	{
	};
  class iPriorityData;
#else
	class iPriorityCustomGui;
  class iPriorityData;
#endif

struct PriorityCustomGuiLib : public BaseCustomGuiLib
{
  Bool    (iPriorityCustomGui::*SetValue)(LONG lValueID, const GeData &data);
  GeData  (iPriorityCustomGui::*GetValue)(LONG lValueID);
  Bool    (iPriorityData::*SetPriorityValue)(LONG lValueID, const GeData &data);
  GeData  (iPriorityData::*GetPriorityValue)(LONG lValueID);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#endif